% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view.R
\name{view}
\alias{view}
\title{Interactively Modify a Seasonal Adjustment Model}
\usage{
view(x = NULL, story = NULL, quiet = TRUE, ...)
}
\arguments{
\item{x}{an object of class \code{"seas"}.}

\item{story}{character, local file path or URL to an \code{".Rmd"} file.}

\item{quiet}{logical, if \code{TRUE} (default), error messages from calls in 
\code{view} are not shown in the console.}

\item{...}{arguments passed to \code{\link[shiny]{runApp}}. E.g., for selecting 
if the GUI should open in the browser or in the RStudio viewer pane.}
}
\value{
\code{view} returns an object of class \code{"seas"}, the modified 
model; or \code{NULL}, if the \code{story} argument is supplied.
}
\description{
Interactively modify a \code{"seas"} object. The goal of \code{view} is 
to summarize all relevant options, plots and statistics of a 
seasonal adjustment model. The \code{view} function in the \pkg{seasonal} 
package imports the identical \code{\link[seasonalview]{view}} function from 
the \pkg{seasonalview} package, so there is no need to explicitly load the 
\pkg{seasonalview} package.
}
\details{
Frequently used options can be modified using the drop down selectors in the
upper left box. Each change will result in a re-estimation of the seasonal
adjustment model. The R-call, the X-13 call, the graphical output and the 
summary are updated accordingly.

Alternatively, the R call can be modified manually in the lower left box.
Click 'Run Call' to re-estimate the model and to adjust the option selectors,
the graphical output, and the summary. With the 'To console' button, 
the GUI is closed and the call is imported to R. The 'Static' button
substitutes automatic procedures by the automatically chosen 
spec-argument options, in the same way as the \code{\link[seasonal]{static}} 
function.

If you are familiar with the X-13 spec syntax, you can modify the X-13 call,
with the same consequences as when modifying the R call.

The lower right panel shows the summary, as described in the help page of
\code{\link[seasonal]{summary.seas}}. The 'X-13 output' button opens the complete 
output of X-13 in a separate tab or window.

If you have the x13story package installed (not yet on CRAN, see references), 
you can call the function with the \code{story} argument. This will render 
an R Markdown document and produce a \emph{story} on seasonal adjustment that 
can be manipulated interactively.
}
\examples{
\dontrun{

m <- seas(AirPassengers)
view(m)

# store the model after closing the GUI, for further processing in R
m.upd <- view(m)  
}
}
\references{
Seasonal vignette with a more detailed description: 
  \url{http://www.seasonal.website/seasonal.html}

  Development version of the x13story package: 
  \url{https://github.com/christophsax/x13story}
}

