% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.seas}
\alias{monthplot.seas}
\alias{plot.seas}
\alias{residplot}
\title{Seasonal Adjustment Plots}
\usage{
\method{plot}{seas}(x, outliers = TRUE, trend = FALSE,
  main = "Original and Adjusted Series", transform = c("none", "PC", "PCY"),
  ...)

residplot(x, outliers = TRUE, main = "residuals of regARIMA", ...)

\method{monthplot}{seas}(x, choice = c("seasonal", "irregular"), ...)
}
\arguments{
\item{x}{an object of class \code{"seas"}, usually, a result of a call to
\code{\link{seas}}.}

\item{outliers}{logical, should the oultiers be drawn.}

\item{trend}{logical, should the trend be drawn.}

\item{main}{character string, title of the graph.}

\item{transform}{character string, optionally transform the data to period to period  \code{"PC"} or year to year\code{"PCY"} percentage change rates.}

\item{choice}{character string, \code{"seasonal"} (default) or
\code{"irregular"}.}

\item{\dots}{further arguments passed to the plotting functions.}
}
\value{
All plot functions return a plot as their side effect.
}
\description{
Functions to graphically analyze a \code{"seas"} object.
}
\details{
\code{plot} calls the plot method for class \code{"seas"}. It plots the
adjusted and unadjusted series, as well as the outliers. Optionally draws the
trend series.

\code{residplot} plots the residuals and the outliers.

\code{monthplot} calls the monthplot method for class \code{"seas"}. It plot
the seasonal and SI component periodwise. Despite its name, \code{monthplot}
can be used for series of all frequencies.
}
\examples{
\dontrun{

m <- seas(AirPassengers)

plot(m)
plot(m, outliers = FALSE)
plot(m, trend = TRUE)

residplot(m)
residplot(m, outliers = FALSE)

monthplot(m)

# use standard R functions to analyze "seas" models
pacf(resid(m))
spectrum(diff(resid(m)))
plot(density(resid(m)))
qqnorm(resid(m))
}
}
\references{
Vignette with a more detailed description:
  \url{http://www.seasonal.website/seasonal.html}

  Comprehensive list of R examples from the X-13ARIMA-SEATS manual:
  \url{http://www.seasonal.website/examples.html}



  Official X-13ARIMA-SEATS manual:
  \url{http://www.census.gov/ts/x13as/docX13AS.pdf}
}
\seealso{
\code{\link{seas}}, for the main function.

\code{\link{qs}}, for diagnostical statistics.
}

