% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getData.R
\name{crawl_errors}
\alias{crawl_errors}
\title{Fetch a time-series of Googlebot crawl errors.}
\usage{
crawl_errors(siteURL, category = "all", platform = c("all", "mobile",
  "smartphoneOnly", "web"), latestCountsOnly = FALSE)
}
\arguments{
\item{siteURL}{The URL of the website to delete. Must include protocol (http://).}

\item{category}{Crawl error category. Defaults to 'all'}

\item{platform}{The user agent type. 'all', 'mobile', 'smartphoneOnly' or 'web'.}

\item{latestCountsOnly}{Default FALSE. Only the latest crawl error counts returned if TRUE.}
}
\value{
dataframe of errors with $platform $category $count and $timecount.
}
\description{
Get a list of errors detected by Googlebot over time.
See here for details: https://developers.google.com/webmaster-tools/v3/urlcrawlerrorscounts/query
}
\details{
The timestamp is converted to a date as they are only available daily.

Category is one of: authPermissions, manyToOneRedirect, notFollowed, notFound,
  other, roboted, serverError, soft404.
  
  Platform is one of: mobile, smartphoneOnly or web.
}
\seealso{
Other working with search console errors: \code{\link{error_sample_url}},
  \code{\link{fix_sample_url}},
  \code{\link{list_crawl_error_samples}}
}

