% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maxkcut.R
\name{maxkcut}
\alias{maxkcut}
\title{Max-kCut Problem}
\usage{
maxkcut(B, K)
}
\arguments{
\item{B}{A (weighted) adjacency matrix}

\item{K}{An integer value, the minimum number of cuts in B}
}
\value{
\item{X}{A list containing the solution matrix to the primal problem}
\item{y}{A list containing the  solution vector to the dual problem}
\item{Z}{A list containing the  solution matrix to the dual problem}
\item{pobj}{The achieved value of the primary objective function}
\item{dobj}{The achieved value of the dual objective function}
}
\description{
\code{maxkcut} creates input for sqlp to solve the Max-kCut Problem -
given a graph object B, determine if a cut of at least size k exists.
}
\details{
Determines if a cut of at least size k exists for a graph B. Mathematical and implementation
details can be found in the vignette
}
\examples{
data(Bmaxkcut)

out <- maxkcut(Bmaxkcut,2)

}
