% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{add_barrier_mesh}
\alias{add_barrier_mesh}
\title{Transform a mesh object into a mesh with correlation barriers}
\usage{
add_barrier_mesh(
  spde_obj = deprecated(),
  barrier_sf = deprecated(),
  range_fraction = 0.2,
  proj_scaling = 1,
  plot = FALSE
)
}
\arguments{
\item{spde_obj}{Output from \code{\link[=make_mesh]{make_mesh()}}.}

\item{barrier_sf}{An sf object with polygons defining the barriers. For
example, a coastline dataset for ocean data. \strong{Note that this object must
have the same projection as the data used to generate the x and y columns
in \code{spde_obj}.}}

\item{range_fraction}{The fraction of the spatial range that barrier
triangles have.}

\item{proj_scaling}{If \code{spde_obj} was created with scaling of the coordinates
after the projection (e.g., dividing UTMs by 1000 so the spatial range is
on a reasonable scale) the x and y values in \code{spde_obj} are multiplied by
this scaling factor before applying the projection from \code{barrier_sf}.}

\item{plot}{Logical.}
}
\value{
Deprecated. See the
\href{https://github.com/pbs-assess/sdmTMBextra}{sdmTMBextra} package.
}
\description{
Moved to the \href{https://github.com/pbs-assess/sdmTMBextra}{sdmTMBextra}
package. Make sure to load \pkg{sdmTMBextra} \emph{after} \pkg{sdmTMB}.
}
\examples{
\dontrun{
add_barrier_mesh()
}
}
\keyword{internal}
