% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mask_sensitive_variable.R
\name{replace_nhsid}
\alias{replace_nhsid}
\title{Replace nhsid with another random nhsid.}
\usage{
replace_nhsid(dataset)
}
\arguments{
\item{dataset}{A data frame of the dataset.}
}
\value{
A data frame of the \code{dataset} with the nhsid column being replaced
    by random nhsid.
}
\description{
\code{replace_nhsid} replaces the nhsid in \code{dataset} with another random nhsid
    in case they are too sensitive.
}
\examples{
df <- data.frame(sex=sample(c('male', 'female'), 100, replace = TRUE))
df$race <- sample(1:6, 100, replace = TRUE)
df <- add_variable(df, "nhsid")
replace_nhsid(df)

}
