% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.r
\docType{class}
\name{sdcProblem-class}
\alias{sdcProblem-class}
\title{S4 class describing a sdcProblem-object}
\description{
An object of class \code{sdcProblem} contains the entire information that is
required to protect the complete table that is given by the dimensional
variables. Such an object holds the data itself  (slot \code{dataObj}), the
entire information about the dimensional variables (slot \code{dimInfo}),
information on all table cells (ID's, bounds, values, anonymization state in
slot \code{problemInstance}), the indices on the subtables that need to be
considered if one wants to protect primary sensitive cells using a heuristic
approach (slot \code{partition}, information on which groups or rather
subtables have already been protected while performing a heuristic method
(slots \code{startI} and \code{startJ}) and the time that has been elapsed
(slot \code{elapsedTime}).
}
\details{
\describe{
\item{slot \code{dataObj}:}{an object of class \code{dataObj} (or NULL) holding information on the underlying data}
\item{slot \code{dimInfo}:}{an object of class \code{dimInfo} (or NULL) containing information on all dimensional variables}
\item{slot \code{problemInstance}:}{an object of class \code{problemInstance} holding information on values, bounds, required protection levels as well as the anonymization state for all table cells}
\item{slot \code{partition}:}{a list object (or NULL) that is typically generated with calc.multiple(type='makePartitions',...) specifying information on the subtables and the necessary order that need to be protected when using a heuristic approach to solve the cell suppression problem}
\item{slot \code{startI}:}{a numeric vector of length 1 defining the group-level of the subtables in which a heuristic algorithm needs to start. All subtables having a group-index less than \code{startI} have already been protected}
\item{slot \code{startJ}:}{a numeric vector of length 1 defining the number of the table within the group defined by parameter \code{startI} at which a heuristic algorithm needs to start. All tables in the group having an index \code{j} smaller than \code{startJ} have already been protected}
\item{slot \code{indicesDealtWith}:}{a numeric vector holding indices of table cells that have protected and whose anonymization state must remain fixed}
\item{slot \code{elapsedTime}:}{a numeric vector of length 1 holding the time that has already been elapsed during the anonymization process}
 }
}
\note{
objects of class \code{sdcProblem} are typically generated by function \code{\link{makeProblem}} and are the input of functions \code{\link{primarySuppression}} and \code{\link{protectTable}}
}
\author{
Bernhard Meindl \email{bernhard.meindl@statistik.gv.at}
}

