% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{SDA_M}
\alias{SDA_M}
\title{Symmetrized Data Aggregation}
\usage{
SDA_M(dat, alpha, Omega, nonsparse = FALSE, stable = TRUE)
}
\arguments{
\item{dat}{a n by p data matrix}

\item{alpha}{the FDR level}

\item{Omega}{the inverse covariance matrix; if missing, it will be estimated
by the glasso package}

\item{nonsparse}{if TRUE, the covariance matrix will be estimated by the POET
package}

\item{stable}{if TRUE, the sample will be randomly splitted B=10 times for stability
performance; otherwise, only single sample splitting is used.}
}
\value{
the indices of the hypotheses rejected
}
\description{
This is the core function for the paper posted in arXiv preprint arXiv:2002.11992
}
\examples{
n = 50
p = 100
dat = matrix(rnorm(n*p), nrow=n)
mu = rep(0, p)
mu[1:as.integer(0.1*p)]=0.3
dat = dat+rep(1, n)\%*\%t(mu)
alpha = 0.2
out = SDA_M(dat, alpha, diag(p))
print(out)

}
