% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdbeta.r
\name{mdbeta}
\alias{mdbeta}
\title{Marginal Density of \eqn{\beta}}
\usage{
mdbeta(D = 1, rangebeta, ngridbeta, a = 5, b = 25, r = 0.00025,
  a0 = 0.5, b0 = 0.5, plot = FALSE, log = FALSE)
}
\arguments{
\item{D}{dimension of \eqn{\beta}.}

\item{rangebeta}{a vector containing the start and ending point of \eqn{\beta} to be computed for.}

\item{ngridbeta}{the number of grid values.}

\item{a}{shape parameter of inverse gamma prior of \eqn{\psi^2}.}

\item{b}{scale parameter of inverse gamma prior of \eqn{\psi^2}.}

\item{r}{the scaling parameter \eqn{r(\delta=1)} in the variance \eqn{r(\delta)\psi^2} of prior of \eqn{\tau^2}.}

\item{a0}{shape parameter of beta prior of \eqn{\omega}.}

\item{b0}{scale parameter of beta prior of \eqn{\omega}.}

\item{plot}{logical value (default is \code{FALSE}). If \code{TRUE}, a plot is also returned as the function \code{pl()}.}

\item{log}{logical value (default is \code{FALSE}). If \code{TRUE}, \eqn{log(p(\beta))} is also returned in \code{logval}.
as well as, if necessary, a plot function \code{logpl()}.}
}
\value{
the marginal density, the sequence of \eqn{\beta} and depending on specified \code{plot}, \code{log} arguments also the log-density and plot functions.
}
\description{
This function computes the marginal density of \eqn{\beta} and for \eqn{\beta} on an equidistant grid specified by the user.
Currently only implemented for \eqn{dim(\beta)=1,2}.
}
\examples{
set.seed(123)
#1-dimensional example
D = 1
ngridbeta = 1000
rangebeta = c(0.000001,1)
a0 = b0 = 0.5
a = 5
b = 50
r = 0.005
mdf <- mdbeta(D=1,rangebeta,ngridbeta,a=a,b=b,r=r,a0=a0,b0=b0) 

#2-dimensional example
D = 2
ngridbeta = 100
rangebeta = c(0.000001,8)
a0 = b0 = 0.5
a = 5
b = 50
r = 0.005
mdf <- mdbeta(D=2,rangebeta,ngridbeta,a=a,b=b,r=r,a0=a0,b0=b0,plot=TRUE,log=TRUE) 
mdf$logpl()

}
\references{
Nadja Klein, Thomas Kneib, Stefan Lang and Helga Wagner (2016). Spike and Slab Priors for Effect Selection in Distributional Regression. 
\emph{Working Paper}.
}
\author{
Nadja Klein
}
