% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/denoise.R
\name{smooth_via_pca}
\alias{smooth_via_pca}
\title{Smooth data by PCA}
\usage{
smooth_via_pca(x, elbow_th = 0.025, dims_use = NULL, max_pc = 100,
  do_plot = FALSE, scale. = FALSE)
}
\arguments{
\item{x}{A data matrix with genes as rows and cells as columns}

\item{elbow_th}{The fraction of PC sdev drop that is considered significant; low values will lead to more PCs being used}

\item{dims_use}{Directly specify PCs to use, e.g. 1:10}

\item{max_pc}{Maximum number of PCs computed}

\item{do_plot}{Plot PC sdev and sdev drop}

\item{scale.}{Boolean indicating whether genes should be divided by standard deviation after centering and prior to PCA}
}
\value{
Smoothed data
}
\description{
Perform PCA, identify significant dimensions, and reverse the rotation using only significant dimensions.
}
\examples{
vst_out <- vst(pbmc)
y_smooth <- smooth_via_pca(vst_out$y, do_plot = TRUE)

}
