% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/row-to-colnames.R
\name{row_to_colnames}
\alias{row_to_colnames}
\title{Turn row values into column names}
\usage{
row_to_colnames(data, row = 1L, collapse = " ", drop = TRUE)
}
\arguments{
\item{data}{Data frame or matrix.}

\item{row}{Integer. Position of the rows (one or more) that jointly contain
the correct column names. Default is \code{1}.}

\item{collapse}{String. If the length of \code{row} is greater than 1, each new
column name will be that many row values pasted together. \code{collapse}, then,
is the substring between two former row values in the final column names.
Default is \code{" "} (a space).}

\item{drop}{Logical. If \code{TRUE} (the default), the rows specified with \code{row}
are removed.}
}
\value{
A tibble (data frame).
}
\description{
Data frames sometimes have wrong column names, while the correct
column names are stored in one or more rows in the data frame itself. To
remedy this issue, call \code{row_to_colnames()} on the data frame: It replaces
the column names by the values of the specified rows (by default, only the
first one). These rows are then dropped by default.
}
\details{
If multiple rows are specified, the row values for each individual
column are pasted together. Some special characters might then be missing.

This function might be useful when importing tables from PDF, e.g. with
\href{https://cran.r-project.org/package=tabulizer}{tabulizer}. In R, these
data frames (converted from matrices) do sometimes have the issue described
above.
}
\seealso{
\code{\link[unheadr:mash_colnames]{unheadr::mash_colnames()}}, a more sophisticated solution to the
same problem.
}
