% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapper-function-helpers.R
\name{check_mapper_input_colnames}
\alias{check_mapper_input_colnames}
\title{Check that a mapper's input has correct column names}
\usage{
check_mapper_input_colnames(data, reported, name_test)
}
\arguments{
\item{data}{Data frame. Input to the mapper function.}

\item{reported}{String vector of the "key" column names that \code{data} must
have, such as \code{c("x", "n")} for \code{grim_map()}.}

\item{name_test}{String (length 1). Short, plain-text name of the consistency
test that the mapper function applies, such as \code{"GRIM"}.}
}
\value{
No return value. Might throw an error.
}
\description{
When called within a consistency test mapper function,
\code{check_mapper_input_colnames()} makes sure that the input data frame has
correct column names:
\itemize{
\item They include all the key columns corresponding to the test applied by the
mapper.
\item They don't already include \code{"consistency"}.
}

If either check fails, the function throws an informative error.
}
\seealso{
\code{vignette("consistency-tests")}, for context and the "key columns"
terminology.
}
