% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grimmer.R
\name{grimmer}
\alias{grimmer}
\title{The GRIMMER test (granularity-related inconsistency of means mapped to error
repeats)}
\usage{
grimmer(
  x,
  sd,
  n,
  items = 1,
  show_reason = FALSE,
  rounding = "up_or_down",
  threshold = 5,
  symmetric = FALSE,
  tolerance = .Machine$double.eps^0.5
)
}
\arguments{
\item{x}{String. The reported mean value.}

\item{sd}{String. The reported standard deviation.}

\item{n}{Integer. The reported sample size.}

\item{items}{Numeric. The number of items composing \code{x}. Default is 1, the
most common case.}

\item{show_reason}{Boolean. For internal use only. If set to \code{TRUE}, the
output is a list of length-2 lists which also contain the reasons for
inconsistencies. Don't specify this manually; instead, use \code{show_reason} in
\code{grimmer_map()}. Default is \code{FALSE}.}

\item{rounding}{String. Rounding method or methods to be used for
reconstructing the values to which \code{x} will be compared. Default is
\code{"up_or_down"} (from 5).}

\item{threshold}{Numeric. If \code{rounding} is set to \code{"up_from"}, \code{"down_from"},
or \code{"up_from_or_down_from"}, set \code{threshold} to the number from which the
reconstructed values should then be rounded up or down. Otherwise, this
argument plays no role. Default is \code{5}.}

\item{symmetric}{Boolean. Set \code{symmetric} to \code{TRUE} if the rounding of
negative numbers with \code{"up"}, \code{"down"}, \code{"up_from"}, or \code{"down_from"}
should mirror that of positive numbers so that their absolute values are
always equal. Default is \code{FALSE}.}

\item{tolerance}{Numeric. Tolerance of comparison between \code{x} and the
possible mean or percentage values. Default is circa 0.000000015
(1.490116e-08), as in \code{dplyr::near()}.}
}
\value{
Boolean. \code{TRUE} if \code{x}, \code{sd}, \code{n}, and \code{items} are mutually
consistent, \code{FALSE} if not.
}
\description{
\code{grimmer()} checks if reported mean and SD values of integer
data are mathematically consistent with the reported sample size and the
number of items that compose the mean value. It works much like \code{grim()}.

The function is vectorized, but it is recommended to use \code{grimmer_map()}
for testing multiple cases.
}
\details{
GRIMMER was originally devised by Anaya (2016). The present
implementation follows Allard's (2018) refined Analytic-GRIMMER (A-GRIMMER)
algorithm. It adapts the R function \code{aGrimmer()} provided by Allard and
modifies it to accord with scrutiny's standards, as laid out in
\code{vignette("consistency-tests")}, sections 1-2. The resulting \code{grimmer()}
function, then, is a vectorized version of this basic implementation. For
more context and variable name translations, see the top of the
R/grimmer.R, the source file.

The present implementation can differ from Allard's in a small number of
cases. In most cases, this means that the original flags a value set as
inconsistent, but scrutiny's \verb{grimmer*()} functions don't. For details, see
the end of tests/testthat/test-grimmer.R, the \code{grimmer()} test file.
}
\examples{
# A mean of 5.23 is not consistent with an SD of 2.55
# and a sample size of 35:
grimmer(x = "5.23", sd = "2.55", n = 35)

# However, mean and SD are consistent with a
# sample size of 31:
grimmer(x = "5.23", sd = "2.55", n = 31)

# For a scale composed of two items:
grimmer(x = "2.74", sd = "0.96", n = 63, items = 2)
}
\references{
Allard, A. (2018). Analytic-GRIMMER: a new way of testing the
possibility of standard deviations.
https://aurelienallard.netlify.app/post/anaytic-grimmer-possibility-standard-deviations/

Anaya, J. (2016). The GRIMMER test: A method for testing the validity of
reported measures of variability. \emph{PeerJ Preprints.}
https://peerj.com/preprints/2400v1/
}
