## ----setup, include = FALSE----------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ---- warning = FALSE----------------------------------------------------
library(scriptexec)

# execute script text
output <- scriptexec::execute("echo Current Directory:\ndir")
cat(sprintf("Exit Status: %s Output: %s\n", output$status, output$output))

# execute multiple commands as a script
output <- scriptexec::execute(c("cd", "echo User Home:", "dir"))
cat(sprintf("Exit Status: %s Output: %s\n", output$status, output$output))

# pass arguments to the script, later defined as ARG1, ARG2, ...
# and also pass some env vars
output <- scriptexec::execute("echo $ARG1 $ARG2 $MYENV", args = c("TEST1", "TEST2"), env = c("MYENV=TEST3"))
cat(sprintf("%s\n", output))

# non zero status code is returned in case of errors
output <- scriptexec::execute("exit 1")
cat(sprintf("Status: %s\n", output$status))
cat(sprintf("%s\n", output))

# do not wait for command to finish
scriptexec::execute("echo my really long task", wait = FALSE)

