% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{iv_table}
\alias{iv_table}
\title{WOE and IV table for list of numerical and categorical variables}
\usage{
iv_table(base, target, num_var_name = F, num_missing = -99999,
  cat_var_name = F, mincriterion = 0.1, event = 1)
}
\arguments{
\item{base}{input dataframe}

\item{target}{column / field name for the target variable to be passed as string (must be 0/1 type)}

\item{num_var_name}{column name or array of column names of numerical variable for which IV is to be calculated, to be passed as string}

\item{num_missing}{(optional) imputed missing value for numerical variable or an array of values which are to be kept as different bucket in binning step (default value is -99999)}

\item{cat_var_name}{column name or array of column names of categorical variable for which IV is to be calculated, to be passed as string}

\item{mincriterion}{(optional) the value of the test statistic or (1 - p-value) that must be exceeded in order to implement a split (default value is 0.1)}

\item{event}{(optional) the event class, to be passed as 0 or 1 (default is 1)}
}
\value{
An object of class "iv_table" is a list containing the following components:

\item{num_woe_table}{numerical woe table with IV as a dataframe}

\item{cat_woe_table}{categorical woe table with IV as a dataframe}

\item{woe_table}{numerical and categorical woe table with IV as a dataframe}

\item{iv_table}{Variable with IV value as a dataframe}
}
\description{
The function takes column indices of categorical and numerical variables and returns a list with four dataframes - WOE table of numerical variables, categorical variables, consolidated table of both numerical & categorical variables and a IV table.
}
\examples{
data <- iris
data$Species <- as.character(data$Species)
data$Y <- sample(0:1,size=nrow(data),replace=TRUE)
x <- c("Sepal.Length","Sepal.Width","Petal.Length","Petal.Width")
iv_table_list <- iv_table(base = data,target = "Y",num_var_name = x,cat_var_name = "Species")
iv_table_list$num_woe_table
iv_table_list$cat_woe_table
iv_table_list$woe_table
iv_table_list$iv_table
}
\author{
Arya Poddar <aryapoddar290990@gmail.com>

Aiana Goyal <aianagoel002@gmail.com>

Kanishk Dogar <kanishkd4@gmail.com>
}
