% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/woebin.R
\name{woebin}
\alias{woebin}
\title{WOE Binning}
\usage{
woebin(dt, y, x = NULL, var_skip = NULL, breaks_list = NULL,
  special_values = NULL, stop_limit = 0.1, count_distr_limit = 0.05,
  bin_num_limit = 8, positive = "bad|1", no_cores = NULL,
  print_step = 0L, method = "tree", save_breaks_list = NULL,
  ignore_const_cols = TRUE, ignore_datetime_cols = TRUE,
  check_cate_num = TRUE, replace_blank_inf = TRUE, ...)
}
\arguments{
\item{dt}{A data frame with both x (predictor/feature) and y (response/label) variables.}

\item{y}{Name of y variable.}

\item{x}{Name of x variables. Defaults to NULL. If x is NULL, then all columns except y and var_skip are counted as x variables.}

\item{var_skip}{Name of variables that will skip for binning. Defaults to NULL.}

\item{breaks_list}{List of break points, Defaults to NULL. If it is not NULL, variable binning will based on the provided breaks.}

\item{special_values}{the values specified in special_values will be in separate bins. Defaults to NULL.}

\item{stop_limit}{Stop binning segmentation when information value gain ratio less than the 'stop_limit' if using tree method; or stop binning merge when the chi-square of each neighbor bins are larger than the threshold under significance level of 'stop_limit' and freedom degree of 1 if using chimerge method. Accepted range: 0-0.5; Defaults to 0.1. If it is 'N', each x value is a bin.}

\item{count_distr_limit}{The minimum count distribution percentage. Accepted range: 0.01-0.2; Defaults to 0.05.}

\item{bin_num_limit}{Integer. The maximum number of binning. Defaults to 8.}

\item{positive}{Value of positive class, defaults to "bad|1".}

\item{no_cores}{Number of CPU cores for parallel computation. Defaults to 90 percent of total cpu cores.}

\item{print_step}{A non-negative integer. Defaults to 1. If print_step>0, print variable names by each print_step-th iteration. If print_step=0 or no_cores>1, no message is print.}

\item{method}{Four methods are provided, "tree" and "chimerge" for optimal binning that support both numerical and categorical variables, and 'width' and 'freq' for equal binning that support numerical variables only. Defaults to "tree".}

\item{save_breaks_list}{A string. The file name to save breaks_list. Defaults to None.}

\item{ignore_const_cols}{Logical. Ignore constant columns. Defaults to TRUE.}

\item{ignore_datetime_cols}{Logical. Ignore datetime columns. Defaults to TRUE.}

\item{check_cate_num}{Logical. Check whether the number of unique values in categorical columns larger than 50. It might make the binning process slow if there are too many unique categories. Defaults to TRUE.}

\item{replace_blank_inf}{Logical. Replace blank values with NA and infinite with -1. Defaults to TRUE.}

\item{...}{Additional parameters.}
}
\value{
A list of data frames include binning information for each x variables.
}
\description{
\code{woebin} generates optimal binning for numerical, factor and categorical variables using methods including tree-like segmentation or chi-square merge. \code{woebin} can also customizing breakpoints if the \code{breaks_list} was provided. The default \code{woe} is defined as ln(Pos_i/Neg_i). If you prefer ln(Neg_i/Pos_i), please set the argument \code{positive} as negative value, such as '0' or 'good'. If there is a zero frequency class when calculating woe, the zero will replaced by 0.99 to make the woe calculable.
}
\examples{
# load germancredit data
data(germancredit)

# Example I
# binning of two variables in germancredit dataset
# using tree method
bins2_tree = woebin(germancredit, y="creditability",
   x=c("credit.amount","housing"), method="tree")
bins2_tree

\dontrun{
# using chimerge method
bins2_chi = woebin(germancredit, y="creditability",
   x=c("credit.amount","housing"), method="chimerge")

# binning in equal freq/width # only supports numerical variables
numeric_cols = c("duration.in.month", "credit.amount",
  "installment.rate.in.percentage.of.disposable.income", "present.residence.since",
  "age.in.years", "number.of.existing.credits.at.this.bank",
  "number.of.people.being.liable.to.provide.maintenance.for")
bins_freq  = woebin(germancredit, y="creditability", x=numeric_cols, method="freq")
bins_width = woebin(germancredit, y="creditability", x=numeric_cols, method="width")

# y can be NULL if no label column in dataset
bins_freq_noy  = woebin(germancredit, y=NULL, x=numeric_cols)

# Example II
# setting of stop_limit
# stop_limit = 0.1 (by default)
bins_x1 = woebin(germancredit, y = 'creditability', x = 'foreign.worker', stop_limit = 0.1)
# stop_limit = 'N', each x value is a bin
bins_x1_N = woebin(germancredit, y = 'creditability', x = 'foreign.worker', stop_limit = 'N')

# Example III
# binning of the germancredit dataset
bins_germ = woebin(germancredit, y = "creditability")
# converting bins_germ into a data frame
# bins_germ_df = data.table::rbindlist(bins_germ)

# Example IV
# customizing the breakpoints of binning
library(data.table)
dat = rbind(
  setDT(germancredit),
  data.table(creditability=sample(c("good","bad"),10,replace=TRUE)),
  fill=TRUE)

breaks_list = list(
  age.in.years = c(26, 35, 37, "Inf\%,\%missing"),
  housing = c("own", "for free\%,\%rent")
)

special_values = list(
  credit.amount = c(2600, 9960, "6850\%,\%missing"),
  purpose = c("education", "others\%,\%missing")
)

bins_cus_brk = woebin(dat, y="creditability",
  x=c("age.in.years","credit.amount","housing","purpose"),
  breaks_list=breaks_list, special_values=special_values)

# Example V
# save breaks_list as a R file
bins2 = woebin(germancredit, y="creditability",
   x=c("credit.amount","housing"), save_breaks_list='breaks_list')

# Example VI
# setting bin closed on the right
options(scorecard.bin_close_right = TRUE)
binsRight = woebin(germancredit, y = 'creditability', x = 'age.in.years')
# setting bin close on the left, the default setting
options(scorecard.bin_close_right = FALSE)
}

}
\seealso{
\code{\link{woebin_ply}}, \code{\link{woebin_plot}}, \code{\link{woebin_adj}}
}
