% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load-ethoscope.R
\name{load_ethoscope}
\alias{load_ethoscope}
\title{Load data from ethoscope result files}
\usage{
load_ethoscope(metadata, min_time = 0, max_time = Inf,
  reference_hour = NULL, verbose = TRUE, columns = NULL, cache = NULL,
  ncores = 1, FUN = NULL, ...)
}
\arguments{
\item{metadata}{\link[data.table:data.table]{data.table::data.table} used to load data (see detail)}

\item{min_time, max_time}{load only data between \code{min_time} and \code{max_time} (in seconds).
This time is \emph{relative to the start of the experiment}.}

\item{reference_hour}{hour, in the day, to use as ZT0 reference.
When unspecified, time will be relative to the start of the experiment.}

\item{verbose}{whether to print progress (a logical)}

\item{columns}{optional vector of columns to be selected from the db file.
Time (t) is always implicitly selected.
When \code{NULL} and if \code{FUN} is set, columns can be retrieved automatically (from the attributes of \code{FUN}).}

\item{cache}{the name of a local directory to cache results for faster subsequent data loading.}

\item{ncores}{number of cores to use for optional parallel processing (experimental).}

\item{FUN}{function (optional) to transform the data from each individual
immediately after is has been loaded.}

\item{...}{extra arguments to be passed to \code{FUN}}
}
\value{
A \link{behavr} table.
In addition to the metadata, it contains the data, with the columns:
\itemize{
\item \code{id} -- autogenerated unique identifier, one per animal
\item \code{t} -- time (s)
\item Several variables recorded by ethoscopes (position, angle, width/height and others), or computed by \code{FUN}.
Distance units (e.g. xy position, height/width) are expressed as a fraction of the width of the ROI they originate from.
}
}
\description{
This function is used to import behavioural data generated
by the \href{http://gilestrolab.github.io/ethoscope/}{ethoscope platform}.
That is it loads multiple \code{.db} files into a single \code{R} \link[behavr:behavr]{behavr::behavr} table.
}
\details{
the linked metadata should be generated using \link{link_ethoscope_metadata}.
}
\examples{
dir <- paste0(scopr_example_dir(), "/ethoscope_results/")
data(region_id_metadata)
metadata <- link_ethoscope_metadata(region_id_metadata, dir)
print(metadata)

# Default data loading
dt <- load_ethoscope(metadata)
dt

# We use reference hour to set zt0 to 09:00 GMT
dt <- load_ethoscope(metadata, reference_hour=9)
dt

# Only load x and y positions
dt <- load_ethoscope(metadata, columns=c("x", "y"), reference_hour=9)
dt
# apply function whilst loading the data
dt <- load_ethoscope(metadata, reference_hour=9, FUN=head)
dt

}
\references{
\itemize{
\item \href{https://rethomics.github.io/behavr.html}{behavr tutorial} -- how to work with the obtained \link{behavr} table
}
}
\seealso{
\itemize{
\item \link[behavr:behavr]{behavr::behavr} -- to understand the output format
\item \link{experiment_info} -- to show information about a file/experiment
\item \link{list_result_files} -- to list available files
}
}
