% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{spectralClones}
\alias{spectralClones}
\title{Spectral clustering-based method for partitioning Ig sequences into clones.}
\usage{
spectralClones(
  db,
  method = c("novj", "vj"),
  germline = "germline_alignment",
  sequence = "sequence_alignment",
  junction = "junction",
  v_call = "v_call",
  j_call = "j_call",
  clone = "clone_id",
  targeting_model = NULL,
  len_limit = NULL,
  first = FALSE,
  cdr3 = FALSE,
  mod3 = FALSE,
  max_n = 0,
  threshold = NULL,
  base_sim = 0.95,
  iter_max = 1000,
  nstart = 1000,
  nproc = 1,
  verbose = FALSE,
  log = NULL,
  summarize_clones = TRUE
)
}
\arguments{
\item{db}{data.frame containing sequence data.}

\item{method}{one of the \code{"novj"} or \code{"vj"}. See Details for description.}

\item{germline}{character name of the column containing the germline or reference sequence.}

\item{sequence}{character name of the column containing input sequences.}

\item{junction}{character name of the column containing junction sequences.
Also used to determine sequence length for grouping.}

\item{v_call}{character name of the column containing the V-segment allele calls.}

\item{j_call}{character name of the column containing the J-segment allele calls.}

\item{clone}{the output column name containing the clone ids.}

\item{targeting_model}{\link{TargetingModel} object. Only applicable if \code{method} = \code{"vj"}. 
See Details for description.}

\item{len_limit}{\link{IMGT_V} object defining the regions and boundaries of the Ig 
sequences. If NULL, mutations are counted for entire sequence. Only 
applicable if \code{method} = \code{"vj"}.}

\item{first}{specifies how to handle multiple V(D)J assignments for initial grouping. 
If \code{TRUE} only the first call of the gene assignments is used. 
If \code{FALSE} the union of ambiguous gene assignments is used to 
group all sequences with any overlapping gene calls.}

\item{cdr3}{if \code{TRUE} removes 3 nucleotides from both ends of \code{"junction"} 
prior to clustering (converts IMGT junction to CDR3 region). 
If \code{TRUE} this will also remove records with a junction length 
less than 7 nucleotides.}

\item{mod3}{if \code{TRUE} removes records with a \code{junction} length that is not divisible by 
3 in nucleotide space.}

\item{max_n}{the maximum number of N's to permit in the junction sequence before excluding the 
record from clonal assignment. Default is set to be zero. Set it as \code{"NULL"} 
for no action.}

\item{threshold}{the supervising cut-off to enforce an upper-limit distance for clonal grouping.
A numeric value between (0,1).}

\item{base_sim}{required similarity cut-off for sequences in equal distances from each other.}

\item{iter_max}{the maximum number of iterations allowed for kmean clustering step.}

\item{nstart}{the number of random sets chosen for kmean clustering initialization.}

\item{nproc}{number of cores to distribute the function over.}

\item{verbose}{if \code{TRUE} prints out a summary of each step cloning process.
if \code{FALSE} (default) process cloning silently.}

\item{log}{output path and filename to save the \code{verbose} log. 
The input file directory is used if path is not specified.
The default is \code{NULL} for no action.}

\item{summarize_clones}{if \code{TRUE} performs a series of analysis to assess the clonal landscape
and returns a \link{ScoperClones} object. If \code{FALSE} then
a modified input \code{db} is returned.}
}
\value{
If \code{summarize_clones=TRUE} (default) a \link{ScoperClones} object is returned that includes the 
clonal assignment summary information and a modified input \code{db} in the \code{db} slot that 
contains clonal identifiers in the specified \code{clone} column.
If \code{summarize_clones=FALSE} modified \code{data.frame} is returned with clone identifiers in the 
specified \code{clone} column.
}
\description{
The \code{spectralClones} function provides an unsupervised computational pipline for 
assigning Ig sequences into clonal groups sharing same V gene, J gene, and junction 
length, based on the junction sequence similarity and shared mutations in V and J segments.
}
\details{
\code{spectralClones} provides a computational platform to explore the B cell clonal 
relationships in high-throughput Adaptive Immune Receptor Repertoire sequencing (AIRR-seq) 
data sets. Two methods are included to perform clustering among sequences of B cell receptors 
(BCRs, immunoglobulins, Ig) that share the same V gene, J gene and junction length: 
\itemize{
      \item If \code{method} = \code{"novj"}: clonal relationships are inferred using an adaptive 
      threshold that indicates the level of similarity among junction sequences in a local neighborhood. 
      \item If \code{method} = \code{"vj"}: clonal relationships are inferred not only based on 
      the junction region homology, but also takes into account the mutation profiles in the V 
      and J segments. Mutation counts are determined by comparing the input sequences (in the 
      column specified by \code{sequence}) to the effective germline sequence (IUPAC representation 
      of sequences in the column specified by \code{germline}). \item Not mandatory, but the 
      influence of SHM hot- and cold-spot biases in the clonal inference process will be noted 
      if a SHM targeting model is provided through argument \code{targeting_model} 
      (see \link{createTargetingModel} for more technical details). 
      \item Not mandatory, but the upper-limit cut-off for clonal grouping can be provided to
      prevent sequences with disimilarity above the threshold group together. Using this argument 
      any sequence with distances above the \code{threshold} value from other sequences, will 
      become a singleton.
}
}
\examples{
# Subset example data
db <- subset(ExampleDb, sample_id == "-1h")

# Find clonal groups
results <- spectralClones(db, method="novj", germline="germline_alignment_d_mask")

# Retrieve modified input data with clonal clustering identifiers
df <- as.data.frame(results)
  
# Plot clonal summaries 
plot(results, binwidth=0.02)

}
\seealso{
See \link{plotCloneSummary} plotting summary results.
}
