% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scmamp.R
\name{postHocTest}
\alias{postHocTest}
\title{Post hoc tests for multiple comparison analises}
\usage{
postHocTest(data, algorithms = NULL, group.by = NULL, test = "friedman",
  control = NULL, use.rank = FALSE, sum.fun = mean, correct = "finner",
  alpha = 0.05, ...)
}
\arguments{
\item{data}{A matrix or data frame containing the results obtained by the algorithms (columns) in each problem (rows). It can contain additional columns, but if any of the column has to be discarderd (not used neither to group the problems nor to be part of the comparison), then it is mandatory to indicate, in the \code{algorithms} parameter, which columns contain the algorithm information.}

\item{algorithms}{Vector with either the names or the indices of the columns that contain the values to be tested. If not provided, the function assumes that all the columns except those indicated in \code{group.by} represent the results obtained by an algorithm.}

\item{group.by}{Vector with either the names or the indices of the columns to be used to group the data. Each group is tested independently. If \code{NULL}, all the data is used for a single comparison.}

\item{test}{Parameter that indicates the statistical test to be used. It can be either a string indicating one of the available test or a function. As a string, it can take the following values:
\itemize{
  \item {\code{'wilcoxon'} - Wilcoxon Signed Rank test, as in Demsar (2006)}
  \item {\code{'t-test'} - t-test (R's t.test function with paired option set at \code{TRUE})}
  \item {\code{'friedman'} - Friedman post hoc test, as in Demsar (2006)}
  \item {\code{'aligned ranks'} Friedman's Aligned Ranks post hoc test, as in Garcia and Herrera (2010)}
  \item {\code{'quade'} - Quade post hoc test, as in Garcia and Herrera (2010)} 
  \item {\code{'tukey'} - Tukey's ANOVA post hoc test, as in Test 28 in Kanji (2006).}
}

If a function is provided, then it has to have as first argument a matrix containing the columns to be compared. The function has to return a  list with, at least, an element named \code{p.value} (as the \code{htest} objects that are usually returned by R's test implementations).}

\item{control}{Either the name or the index of a column in the dataset (one of those in the \code{algorithms} vector), to be used as control. Alternatively, this argument can be \code{'min'}, to select the algorithm with the minimum value, \code{'max'}, to select the algorithm with the maximum value as control. If the argument is not provided (or is \code{NULL}), all the pairwise comparisons are performed instead of all vs. control comparisons.}

\item{use.rank}{If \code{TRUE}, then the summarization of the data is based on the ranks, rather than on the actual values. The selecion of the algorithm with the maximum or minimum value is also done in terms of the summarized ranking.}

\item{sum.fun}{Function to be used to summarize the data. By default, average is used.}

\item{correct}{Either string indicating the type of correction that has to be applied or a function to correct the p-values for multiple testing; This parameter is only need in case the data is grouped. As a string, the valid values are:
\itemize{
  \item{\code{shaffer} - Shaffer's (static) procedure, as in Garcia and Herrera (2008)}
  \item{\code{bergmann} - Bergman and Hommel's  procedure (similar to Shaffer dynamic), as in Garcia and Herrera (2008)}
  \item{\code{holland} - Holland's procedure, as in Garcia and Herrera (2010)}
  \item{\code{finner} - Finner's procedure, as in Garcia and Herrera (2010)}
  \item{\code{rom} - Rom's procedure, as in Garcia and Herrera (2010)} 
  \item{\code{li} - Li's procedure, as in Garcia and Herrera (2010)}
  \item{Any of the methods implemented in the \code{p.adjust} function. For a list of options, type \code{p.adjust.methods}}
}. 
If a function is provided, the it has to recieve, as first argument, a vector of pvalues to be corrected and has to return a verctor with the corrected p-values \emph{in the same order} as the input vector.}

\item{alpha}{Alpha value used in Rom's correction. By default, it is set at 0.05.}

\item{...}{Special argument used to pass additional parameters to the statistical test and the correction method.}
}
\value{
In all cases the function returns a list with three elements, the summarization of the data (a row per group), the raw p-values and the corrected p-values. When the data is grouped and all the pairwise comparisons are performed (no control is provided), the p-values are in three dimensional arrays where the last dimension is corresponds to the group. In any other cases the result is a matrix with one or more rows.

Note that Shaffer and Bergmann and Hommel's correction can only be applied when all the pairwise tests are conducted, due to their assumptions. Moreover, its use when the data is grouped (multiple pairwise comparsions) is not trivial and, thus, it is not possible to use it when the data is grouped.
}
\description{
This function is a wrapper to run the post hoc tests. It can run both all vs. control and all vs. all post hoc tests.
}
\examples{
# Grouped data, all pairwise
data(data_blum_2015)
res <- postHocTest (data=data.blum.2015, algorithms=c("FrogCOL", "FrogMIS", "FruitFly"), 
                    use.rank=TRUE, group.by=c("Size"), test="quade", correct="finner")
                   
# Data summarization
res$summary

# Corrected pvalues for the first group
res$corrected.pval[, , 1]

# Grouped data, all vs. control
res <- postHocTest (data=data.blum.2015, control="max", use.rank=FALSE, 
                    group.by=c("Size","Radius"), test="wilcoxon", correct="finner")
                   
# Data summarization
res$summary

# Corrected pvalues
res$corrected.pval
                                       
# Not grouped data
data(data_gh_2008)
postHocTest (data=data.gh.2008, test="aligned ranks", correct="bergmann")

}
\references{
S. Garcia and F. Herrera (2010) Advanced nonparametric tests for multiple comparisons in the design of experiments in computational intelligence and ata mining: Experimental analysis of power. \emph{Information Sciences}, 180, 2044-2064.

Garcia S. and Herrera, F. (2008) An Extension on "Statistical Comparisons of Classifiers over Multiple Data Sets" for All Pairwise Comparisons. \emph{Journal of Machine Learning Research}, 9, 2677-2694.

Kanji, G. K. (2006) \emph{100 Statistical Tests}. SAGE Publications Ltd, 3rd edition.

Demsar, J. (2006) Statistical Comparisons of Classifiers over Multiple Data Sets. \emph{Journal of Machine Learning Research}, 7, 1-30.
}
\seealso{
\code{\link{friedmanPost}}, \code{\link{friedmanAlignedRanksPost}}, \code{\link{quadePost}}, \code{\link{tukeyPost}}, \code{\link{adjustShaffer}}, \code{\link{adjustBergmannHommel}}, \code{\link{adjustHolland}}, \code{\link{adjustFinner}}, \code{\link{adjustRom}}, \code{\link{adjustLi}}
}

