% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/winsorZ_find.R
\name{winsorZ_find}
\alias{winsorZ_find}
\title{Identify outliers based on z-score cutoff
that are Winsorized by the \code{winsorZ} function}
\usage{
winsorZ_find(x, zbound = 3)
}
\arguments{
\item{x}{The input variable to check for Z-score outliers.}

\item{zbound}{The Z-score cutoff (default=3, i.e. outliers are Z>3 | Z<-3).}
}
\value{
Output logical variable of Z-score outliers
}
\description{
The \code{winsorZ_find} function is an optional
companion to the \code{winsorZ} function.
The \code{winsorZ} function identifies Z-score outliers and
replaces with the next most extreme non-outlier value.
The \code{winsorZ_find} function finds/identifies these
Z-score outliers (outliers=1, non-outliers=0).
}
\examples{
summary(winsorZ_find(psydat$iq))
\dontrun{
psydat \%>\% mutate_at(c("iq", "anxT"), list(out = ~ winsorZ_find(.)))
}

}
