% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{StatDBAttribute}
\alias{StatDBAttribute}
\title{Stat Database Attributes.}
\usage{
StatDBAttribute(
  df,
  filter,
  database = c("PanglaoDB", "UCSC", "CELLxGENE", "HCA")
)
}
\arguments{
\item{df}{All metadata, can be \code{PanglaoDBMeta} and obtained with \code{ShowCBDatasets}, \code{ShowCELLxGENEDatasets},
and \code{ShowHCAProjects}.}

\item{filter}{Vector of attributes.}

\item{database}{Database name, choose from "PanglaoDB", "UCSC", "CELLxGENE", "HCA". Default: "PanglaoDB".}
}
\value{
List of attributes information, including attribute, value and number.
}
\description{
Stat Database Attributes.
}
\examples{
\dontrun{
# PanglaoDB
StatDBAttribute(df = PanglaoDBMeta, filter = c("species", "protocol"), database = "PanglaoDB")
# UCSC Cell Browser, need users to provide the json folder
ucsc.cb.samples <- ShowCBDatasets(lazy = TRUE, json.folder = NULL, update = FALSE)
StatDBAttribute(df = ucsc.cb.samples, filter = c("organism", "organ"), database = "UCSC")
# CELLxGENE
all.cellxgene.datasets <- ShowCELLxGENEDatasets()
StatDBAttribute(
  df = all.cellxgene.datasets, filter = c("organism", "sex"),
  database = "CELLxGENE"
)
# HCA
all.hca.projects <- ShowHCAProjects()
StatDBAttribute(df = all.hca.projects, filter = c("organism", "sex"), database = "HCA")
}
}
