% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hca.R
\name{ParseHCA}
\alias{ParseHCA}
\title{Download Human Cell Atlas Datasets.}
\usage{
ParseHCA(
  meta,
  file.ext = c("rds", "rdata", "h5", "h5ad", "loom"),
  out.folder = NULL,
  timeout = 3600,
  quiet = FALSE,
  parallel = TRUE
)
}
\arguments{
\item{meta}{Metadata used to download, can be from \code{ExtractHCAMeta},
should contain entryId and name catalog.}

\item{file.ext}{The valid file extension for download. When NULL, use "rds", "rdata", "h5", "h5ad", "loom".
Default: c("rds", "rdata", "h5", "h5ad", "loom").}

\item{out.folder}{The output folder. Default: NULL (current working directory).}

\item{timeout}{Maximum request time. Default: 3600.}

\item{quiet}{Logical value, whether to show downloading progress. Default: FALSE (show).}

\item{parallel}{Logical value, whether to download parallelly. Default: TRUE. When "libcurl" is available for \code{download.file},
the parallel is done by default (\code{parallel} can be FALSE).}
}
\value{
Dataframe contains failed projects or NULL.
}
\description{
Download Human Cell Atlas Datasets.
}
\examples{
\dontrun{
# all available projects
all.hca.projects <- ShowHCAProjects()
# all human and 10x 3' v2
all.human.10x.projects <- ExtractHCAMeta(
  all.projects.df = all.hca.projects,
  organism = "Homo sapiens",
  protocol = c("10x 3' v2", "10x 3' v3")
)
# download, need users to provide the output folder
ParseHCA(meta = all.human.10x.projects, out.folder = "/path/to/output")
}
}
