% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GEO.R
\name{ParseGEO}
\alias{ParseGEO}
\title{Download Matrix from GEO and Load to Seurat.}
\usage{
ParseGEO(
  acce,
  platform = NULL,
  down.supp = FALSE,
  supp.idx = 1,
  timeout = 3600,
  data.type = c("sc", "bulk"),
  supp.type = c("count", "10x"),
  out.folder = NULL,
  gene2feature = TRUE,
  merge = TRUE,
  ...
)
}
\arguments{
\item{acce}{GEO accession number.}

\item{platform}{Platform information/field. Disable when \code{down.supp} is TRUE. Default: NULL (disable).}

\item{down.supp}{Logical value, whether to download supplementary files to create count matrix. If TRUE, always
download supplementary files. If FALSE, use \code{ExpressionSet} (If contains non-integer or empty,
download supplementary files automatically). Default: FALSE.}

\item{supp.idx}{The index of supplementary files to download. This should be consistent with \code{platform}. Default: 1.}

\item{timeout}{Timeout for \code{\link{download.file}}. Default: 3600.}

\item{data.type}{The data type of the dataset, choose from "sc" (single-cell) and "bulk" (bulk). Default: "sc".}

\item{supp.type}{The type of downloaded supplementary files, choose from count (count matrix file or single count matrix file)
and 10x (cellranger output files, contains barcodes, genes/features and matrix). Default: count.}

\item{out.folder}{Output folder to save 10x files. Default: NULL (current working directory).}

\item{gene2feature}{Logical value, whether to rename \code{genes.tsv.gz} to \code{features.tsv.gz}. Default: TRUE.}

\item{merge}{Logical value, whether to merge Seurat list when there are multiple 10x files (\code{supp.type} is 10x). Default: FALSE.}

\item{...}{Parameters for \code{\link{getGEO}}.}
}
\value{
If \code{data.type} is "sc", return Seurat object (if \code{merge} is TRUE) or Seurat object list (if \code{merge} is FALSE).
If \code{data.type} is "bulk", return count matrix.
}
\description{
Download Matrix from GEO and Load to Seurat.
}
\examples{
\dontrun{
# the supp files are count matrix
GSE94820.seu <- ParseGEO(acce = "GSE94820", down.supp = TRUE, supp.idx = 1, supp.type = "count")
# the supp files are cellranger output files: barcodes, genes/features and matrix
# need users to provide the output folder
GSE200257.seu <- ParseGEO(
  acce = "GSE200257", down.supp = TRUE, supp.idx = 1, supp.type = "10x",
  out.folder = "/path/to/output/folder"
)
}
}
