% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PanglaoDB.R
\name{ExtractPanglaoDBMeta}
\alias{ExtractPanglaoDBMeta}
\title{Extract Metadata of scRNA-seq Datasets in PanglaoDB.}
\usage{
ExtractPanglaoDBMeta(
  species = NULL,
  protocol = NULL,
  tissue = NULL,
  cell.num = NULL,
  show.cell.type = TRUE,
  local.data = TRUE
)
}
\arguments{
\item{species}{The species of the datasets, choose from "Homo sapiens", "Mus musculus", one or multiple value. Default: NULL (All).}

\item{protocol}{Protocol used to generate the datasets, choose from "10x chromium", "drop-seq", "microwell-seq",
"C1 Fluidigm", "inDrops", "Smart-seq2", "CEL-seq", one or multiple value. Default: NULL (All).}

\item{tissue}{The tissue of the datasets, obtain available values with \code{StatDBAttribute}. Default: NULL (All).}

\item{cell.num}{Cell number filter. If NULL, no filter; if one value, lower filter; if two values, low and high filter. Deault: NULL.}

\item{show.cell.type}{Logical value, whether to show inferred cell type. Default: TRUE.}

\item{local.data}{Logical value, whether to use local data (PanglaoDB is no longer maintained). Default: TRUE.}
}
\value{
Dataframe contains SRA, SRS, Tissue, Protocol, Species, Cells, CellType (inferred).
}
\description{
Extract Metadata of scRNA-seq Datasets in PanglaoDB.
}
\examples{
\donttest{
human.meta <- ExtractPanglaoDBMeta(
  species = "Homo sapiens",
  protocol = c("Smart-seq2", "10x chromium"),
  cell.num = c(1000, 2000)
)
}
}
