% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hca.R
\name{ExtractHCAMeta}
\alias{ExtractHCAMeta}
\title{Extract Metadata of Human Cell Atlas Projects with Attributes.}
\usage{
ExtractHCAMeta(
  all.projects.df,
  organism = NULL,
  sex = NULL,
  organ = NULL,
  organ.part = NULL,
  disease = NULL,
  sample.type = NULL,
  preservation.method = NULL,
  protocol = NULL,
  suspension.type = NULL,
  cell.type = NULL,
  cell.num = NULL,
  sequencing.type = NULL
)
}
\arguments{
\item{all.projects.df}{All detail information of HCA projects, obtained with \code{ShowHCAProjects}.}

\item{organism}{The organism of the projects, choose from "Homo sapiens", "Mus musculus",
"Macaca mulatta", "canis lupus familiaris", one or multiple values. Default: NULL (All).}

\item{sex}{The sex of the projects, choose from "female", "male", "mixed", "unknown",
one or multiple values. Default: NULL (All).}

\item{organ}{The organ of the projects (e.g. brain), obtain available values with \code{StatDBAttribute},
one or multiple values. Default: NULL (All).}

\item{organ.part}{The organ part of the projects (e.g. cortex), obtain available values with \code{StatDBAttribute},
one or multiple values. Default: NULL (All).}

\item{disease}{The disease of the projects (e.g. normal), obtain available values with \code{StatDBAttribute},
one or multiple values. Default: NULL (All).}

\item{sample.type}{The sex of the projects, choose from "specimens", "organoids", "cellLines",
one or multiple values. Default: NULL (All).}

\item{preservation.method}{The preservation method of the projects (e.g. fresh), obtain available values with \code{StatDBAttribute},
one or multiple values. Default: NULL (All).}

\item{protocol}{The protocol of the projects (e.g. 10x 3' v2), obtain available values with \code{StatDBAttribute},
one or multiple values. Default: NULL (All).}

\item{suspension.type}{The suspension type of the projects, choose from "single cell", "single nucleus", "bulk cell", "bulk nuclei",
one or multiple values. Default: NULL (All).}

\item{cell.type}{The cell type of the projects (e.g. neuron), obtain available values with \code{StatDBAttribute},
one or multiple values. Default: NULL (All).}

\item{cell.num}{Cell number filter. If NULL, no filter; if one value, lower filter; if two values, low and high filter.
Deault: NULL(without filtering).}

\item{sequencing.type}{The sequencing instrument type of the projects (e.g. illumina hiseq 2500),
obtain available values with \code{StatDBAttribute}, one or multiple values. Default: NULL (All).}
}
\value{
Dataframe contains filtered projects.
}
\description{
Extract Metadata of Human Cell Atlas Projects with Attributes.
}
\examples{
\donttest{
# all available projects
all.hca.projects <- ShowHCAProjects()
# all human projects
all.human.projects <- ExtractHCAMeta(all.projects.df = all.hca.projects, organism = "Homo sapiens")
# all human and 10x 3' v2
all.human.10x.projects <- ExtractHCAMeta(
  all.projects.df = all.hca.projects,
  organism = "Homo sapiens",
  protocol = c("10x 3' v2", "10x 3' v3")
)
}
}
\references{
https://bioconductor.org/packages/release/bioc/html/hca.html
}
