% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{dotPlot}
\alias{dotPlot}
\title{Dot plot adapted from Seurat:::DotPlot, see ?Seurat:::DotPlot for details}
\usage{
dotPlot(
  markers,
  count.matrix,
  cell.groups,
  marker.colour = "black",
  cluster.colour = "black",
  xlab = "Marker",
  ylab = "Cluster",
  n.cores = 1,
  text.angle = 45,
  gene.order = NULL,
  cols = c("blue", "red"),
  col.min = -2.5,
  col.max = 2.5,
  dot.min = 0,
  dot.scale = 6,
  scale.by = "radius",
  scale.min = NA,
  scale.max = NA,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{markers}{Vector of gene markers to plot}

\item{count.matrix}{Merged count matrix, cells in rows and genes in columns}

\item{cell.groups}{Named factor containing cell groups (clusters) and cell names as names}

\item{marker.colour}{Character or numeric vector (default="black")}

\item{cluster.colour}{Character or numeric vector (default="black")}

\item{xlab}{string X-axis title (default="Marker")}

\item{ylab}{string Y-axis title (default="Cluster")}

\item{n.cores}{integer Number of cores (default=1)}

\item{text.angle}{numeric Angle of text displayed (default=45)}

\item{gene.order}{Either factor of genes passed to dplyr::mutate(levels=gene.order), or a boolean. (default=NULL) If TRUE, gene.order is set to the unique markers. If FALSE, gene.order is set to NULL. If NULL, the argument is ignored.}

\item{cols}{Colors to plot (default=c("blue", "red")). The name of a palette from 'RColorBrewer::brewer.pal.info', a pair of colors defining a gradient, or 3+ colors defining multiple gradients (if 'split.by' is set).}

\item{col.min}{numeric Minimum scaled average expression threshold (default=-2.5). Everything smaller will be set to this.}

\item{col.max}{numeric Maximum scaled average expression threshold (default=2.5). Everything larger will be set to this.}

\item{dot.min}{numeric The fraction of cells at which to draw the smallest dot (default=0). All cell groups with less than this expressing the given gene will have no dot drawn.}

\item{dot.scale}{numeric Scale the size of the points, similar to cex (default=6)}

\item{scale.by}{string Scale the size of the points by 'size' or by 'radius' (default="radius")}

\item{scale.min}{numeric Set lower limit for scaling, use NA for default (default=NA)}

\item{scale.max}{numeric Set upper limit for scaling, use NA for default (default=NA)}

\item{verbose}{boolean Verbose output (default=TRUE)}

\item{...}{Additional inputs passed to sccore::plapply(), see man for description.}
}
\value{
ggplot2 object
}
\description{
Dot plot adapted from Seurat:::DotPlot, see ?Seurat:::DotPlot for details
}
\examples{
library(dplyr)
## Create merged count matrix
## In this example, cms is a list of count matrices from, e.g., Cellranger count,
## where cells are in columns and genes in rows
## cm <- sccore:::mergeCountMatrices(cms, transposed = FALSE) \%>\% Matrix::t()

## If coming from Conos, this can be extracted like so
## cm <- conos.obj$getJointCountMatrix(raw = FALSE) # Either normalized or raw values can be used

## Here, we create a random sparse matrix
cm <- Matrix::rsparsematrix(30,3,0.5) \%>\% abs(.) \%>\%
            `dimnames<-`(list(1:30,c("gene1","gene2","gene3")))

## Create marker vector
markers <- c("gene1","gene2","gene3")

## Additionally, color vectors can be included.
## These should have the same length as the input (markers, cell groups)
## Otherwise, they are recycled
col.markers <- c("black","black","red") # or c(1,1,2)
col.clusters <- c("black","red","black") # or c(1,2,1)

## Create annotation vector
annotation <- c(rep("cluster1",10),rep("cluster2",10),rep("cluster3",10)) \%>\%
    factor() \%>\% setNames(1:30)

## Plot. Here, the expression colours range from gray (low expression) to purple (high expression)
sccore:::dotPlot(markers = markers, count.matrix = cm, cell.groups = annotation,
    marker.colour = col.markers, cluster.colour = col.clusters, cols=c("gray","purple"))

}
