% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cplot.R
\name{cplot.log_root_axes}
\alias{cplot.log_root_axes}
\title{Add log-root axes to histogram plot}
\usage{
cplot.log_root_axes(points)
}
\arguments{
\item{points}{The data to plot}
}
\description{
Add log-root axes to histogram plot
}
\examples{

infile <- system.file("extdata", "example1_qub.dwt", package = "scbursts")
dwells <- dwt.read(infile)
dwells_c <- risetime.correct_gaussian(Tr=35.0052278, dwells, units="us")
bursts <- bursts.defined_by_tcrit(dwells_c, 100, units="ms")

open_dwells <- segment.open_dwells(bursts.recombine(bursts))
hist(log10(open_dwells), axes=FALSE, breaks=30)
cplot.log_root_axes(open_dwells)

}
