% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bursts.R
\name{bursts.popens}
\alias{bursts.popens}
\title{Return popens of every burst.}
\usage{
bursts.popens(bursts)
}
\arguments{
\item{bursts}{The list of all bursts}
}
\value{
The popen values
}
\description{
Return popens of every burst.
}
\examples{

infile <- system.file("extdata", "example1_qub.dwt", package = "scbursts")
dwells <- dwt.read(infile)
dwells_c <- risetime.correct_gaussian(Tr=35.0052278, dwells, units="us")

bursts <- bursts.defined_by_tcrit(dwells_c, 100, units="ms")

popens <- bursts.popens(bursts)
hist(popens)

}
