% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zones.R
\name{knn_zones}
\alias{knn_zones}
\title{Find the increasing subsets of \eqn{k} nearest neighbors for all locations.}
\usage{
knn_zones(k_nearest, .parallel = FALSE, .paropts = NULL)
}
\arguments{
\item{k_nearest}{An integer matrix of with \eqn{k} columns and as many rows
as locations. The first element of each row is the integer encoding the
location (and equal to the row number); the following elements are the 
\eqn{k-1} nearest neighbors in ascending order of distance.}

\item{.parallel}{if \code{TRUE}, apply function in parallel, using parallel
backend provided by foreach}

\item{.paropts}{a list of additional options passed into
the \code{\link[foreach]{foreach}} function when parallel computation
is enabled.  This is important if (for example) your code relies on
external data or packages: use the \code{.export} and \code{.packages}
arguments to supply them so that all cluster nodes have the correct
environment set up for computing.}
}
\value{
A list of integer vectors.
}
\description{
Returns the set of increasing nearest neighbor sets for all locations, as
a list of integer vectors. That is, for each location the list returned 
contains one vector containing the location itself, another containing the 
location and its nearest neighbor, and so on, up to the vector containing the 
location and its \eqn{k-1} nearest neighbors.
}
\examples{
nn <- matrix(c(1L, 2L, 4L, 3L, 5L,
               2L, 1L, 3L, 4L, 5L, 
               3L, 2L, 4L, 1L, 5L,
               4L, 1L, 2L, 3L, 5L,
               5L, 3L, 4L, 2L, 1L),
               ncol = 5, byrow = TRUE)
knn_zones(nn[, 1:3])
}

