% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scan_zip.R
\name{generate_zip_counts}
\alias{generate_zip_counts}
\title{Randomly generate and add ZIP-distributed counts to a table.}
\usage{
generate_zip_counts(table, abs_tol = 0.001)
}
\arguments{
\item{table}{A \code{data.table} with columns \code{mu} and \code{p}. These
correspond to the parameters \code{mu} and \code{sigma} in 
\code{\link[gamlss.dist]{rZIP}}; the former is the Poisson expected value
parameter and the latter is the excess zero probability.}

\item{abs_tol}{A scalar; if the excess zero probability is less than this 
value the count will be generated from a Poisson distribution.}
}
\value{
The same table, with a new column \code{count}.
}
\description{
This function randomly generates counts from a zero-inflated Poisson 
distribution according to the parameters on each row of the input 
\code{data.table}, and adds the counts to a new column \code{count}.
}
\keyword{internal}

