% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.scdf.R
\name{transform.scdf}
\alias{transform.scdf}
\title{Transform variables in every single case of a single case data frame}
\usage{
\method{transform}{scdf}(`_data`, ...)
}
\arguments{
\item{_data}{A scdf.}

\item{...}{Expressions.}
}
\value{
A scdf.
}
\description{
Takes a scdf and applies transformations to each individual case. This is
useful to calculate or modify new variables.
}
\details{
This function is a method of the generic transformation function. Unlike this
one, expressions are calculated serially. This means that the results of the
calculation of an expression are the basis for the following calculations.
}
\examples{
## Creates a single-case with frequency distributions. The proportion and
## percentage of the frequencies are calculated with transform:
design <- design(
 n = 3,
 level = 5,
 distribution = "binomial",
 n_trials = 20,
 start_value = 0.5
)
study <- random_scdf(design)
transform(study, proportion = values/trials, percentage = proportion * 100)

## Z standardize the dependent variable and add two new variables:
exampleAB \%>\% 
  transform(
    values = scale(values), 
    mean_values = mean(values), 
    sd_values = sd(values)
  )
}
