% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCALPEL_graphics.R
\name{plotThresholdedFrame}
\alias{plotThresholdedFrame}
\title{Plot a frame of the video with shading.}
\usage{
plotThresholdedFrame(
  scalpelOutput,
  frame,
  threshold,
  shrinkLargest = FALSE,
  shrinkCutoff = NULL,
  title = NULL,
  col = "yellow",
  Y = NULL
)
}
\arguments{
\item{scalpelOutput}{An object returned by one of the SCALPEL functions:
\code{\link{scalpel}}, \code{\link{scalpelStep0}}, \code{\link{scalpelStep1}}, \code{\link{scalpelStep2}}, or \code{\link{scalpelStep3}}.}

\item{frame}{The frame to plot.}

\item{threshold}{Value above which pixels will be shaded.}

\item{shrinkLargest}{Logical value indicating whether the values above \code{shrinkCutoff} should be shrunk when plotting. Shrinking these values
allows us to better visualize the areas with the largest fluorescence.}

\item{shrinkCutoff}{The value above which pixel values will be shrunk. By default, this will be chosen as
\code{scalpelOutput$lowThreshold} if \code{class(scalpelOutput)=="scalpelStep0"} or \code{min(scalpelOutput$thresholdVec)} otherwise.}

\item{title}{Label for the title. By default, it gives the threshold value.}

\item{col}{Color of shading to use, which is yellow by default.}

\item{Y}{An object of class \code{scalpelY}, which results from running the \code{\link{getY}} function. When not specified, \code{Y}
is automatically read in, but specifying \code{Y} is recommended when the user
would like to call this function many times, as this avoids reading the video into memory repeatedly.}
}
\value{
None
}
\description{
We plot a specified frame of the processed video, which results from Step 0 of SCALPEL,
with shading to indicate values above a specified threshold.
}
\examples{
\dontrun{
### many of the functions in this package are interconnected so the
### easiest way to learn to use the package is by working through the vignette,
### which is available at ajpete.com/software

#assumes you have run the example for the "scalpel" function

#simplest example with default parameters:
plotThresholdedFrame(scalpelOutput = scalpelOutput, frame = 100,
                    threshold = scalpelOutput$thresholdVec[1])

#example with optional parameters:
#change shading to purple and add a title
plotThresholdedFrame(scalpelOutput = scalpelOutput, frame = 100, col = "purple",
                   threshold = scalpelOutput$thresholdVec[2])

#if you have video data read in already using 'getY' function, you can provide it
processedY = getY(scalpelOutput = scalpelOutput, videoType = "processed")
plotThresholdedFrame(scalpelOutput = scalpelOutput, frame = 100,
                    threshold = scalpelOutput$thresholdVec[1], Y = processedY)
}
}
\seealso{
\code{\link{scalpelStep0}}, \code{\link{scalpel}}
}
