% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{PlotSimulation}
\alias{PlotSimulation}
\title{Plot Simulation}
\usage{
PlotSimulation(
  sim_object,
  nrow = 1,
  ncol = 1,
  which = 1,
  what = "tissue heatmap"
)
}
\arguments{
\item{sim_object}{A \code{SpatSimObj}}

\item{nrow}{Number of rows of plots (only applicable when more than one plot is made)}

\item{ncol}{Number of columns of plots (only applicable when more than one plot is made)}

\item{which}{Index of the elements of the SpatSimObj to be plotted}

\item{what}{What to plot ("tissue heatmap", "hole heatmap", or "whole core")}
}
\value{
A plot or a grid of plots, depending on the input arguments
}
\description{
Plot different aspects of a SpatSimObj
}
\details{
The \code{PlotSimulation} function is used to plot different aspects of a SpatSimObj
The function takes a \code{sim_object} as its first argument, which should be an object of class
"Spatial Simulation Object". The function can then be used to plot different aspects of the
simulation, such as heatmaps of the tissue or holes, or a plot of the whole core with assigned cells colored by type.

When \code{what} is set to "tissue heatmap" or "hole heatmap", the function will plot heatmaps of
the specified tissue or hole. When \code{what} is set to "whole core", the function will plot the
entire core with assigned cells colored by type. Only a single element of the \code{sim_object} can
be plotted when \code{what} is set to "whole core". \code{what} equal to "tissue points", "hole points", or
"tissue hole points" will result in a point plot of the respective assignments on points.

When more than one plot is made, \code{nrow} and \code{ncol} can be used to specify the number of rows
and columns of the plot grid, respectively.
}
\examples{
# create a SpatSimObj
sim_object <- CreateSimulationObject()
sim_object = GenerateSpatialPattern(sim_object)
sim_object = GenerateTissue(sim_object, density_heatmap = TRUE, step_size = 1, cores = 1)
# plot a heatmap of tissue 1
PlotSimulation(sim_object, which = 1, what = "tissue heatmap")
}
