% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tissue_scMappR_internal.R
\name{tissue_scMappR_internal}
\alias{tissue_scMappR_internal}
\title{Gene List Visualization and Enrichment (Internal)}
\usage{
tissue_scMappR_internal(
  gene_list,
  species,
  output_directory,
  tissue,
  rda_path = "",
  cluster = "Pval",
  genecex = 0.01,
  raw_pval = FALSE,
  path = NULL,
  toSave = FALSE,
  drop_unkown_celltype = FALSE
)
}
\arguments{
\item{gene_list}{A list of gene symbols, mouse or human.}

\item{species}{"mouse", "human" or "-9" if using a precomputed signature matrix.}

\item{output_directory}{If toSave = TRUE, the name of the output directory that would be built.}

\item{tissue}{Name of the tissue in "get_tissues".}

\item{rda_path}{Path to the .rda file containing all of the signature matrices.}

\item{cluster}{'Pval' or 'OR' depending on if you want to cluster odds ratios or p-values of cell-type preferences.}

\item{genecex}{The size of the gene names of the rows in the heatmap.}

\item{raw_pval}{If the inputted signature matrix are raw (untransformed) p-values -- recommended to generate rank first (T/F).}

\item{path}{If toSave == TRUE, path to the directory where files will be saved.}

\item{toSave}{Allow scMappR to write files in the current directory (T/F).}

\item{drop_unkown_celltype}{Whether or not to remove "unknown" cell-types from the signature matrix (T/F).}
}
\value{
List with the following elements:
\item{background_heatmap}{Data frame of the entire gene by cell-type signature matrix inputted.}
\item{gene_list_heatmap}{Data frame of inputted signature matrix subsetted by input genes.}
\item{single_celltype_preferences}{Data frame of enriched cell-types.}
\item{group_celtype_preference}{Data frame of groups of cell-types enriched by the same genes.}
}
\description{
This function loops through every signature matrix in a particular tissue and generates heatmaps, cell-type preferences, and co-enrichment.
}
\details{
This function takes a list of genes and a tissue that is contained in current signature matrices before and generating heatmaps of cell-type preferences.
It then completes cell-type enrichment of each individual cell-type, then, if more than two cell-types are significantly enriched, co-enrichment.
of those enriched cell-types is then computed.
}
\examples{
\donttest{

data(POA_example) # region to preoptic area
Signature <- POA_example$POA_Rank_signature # signature matrix
rowname <- get_gene_symbol(Signature) # get signature
rownames(Signature) <- rowname$rowname
genes <- rownames(Signature)[1:60]
rda_path1 = "" # data directory (if it exists)

# set toSave = TRUE and path = output directory of your choice
internal <- tissue_scMappR_internal(genes, "mouse", output_directory = "scMappR_TesInternal",
                                   tissue = "hypothalamus", toSave = FALSE) 

 }
}
