% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_deconvolution_methods.R
\name{compare_deconvolution_methods}
\alias{compare_deconvolution_methods}
\title{compare_deconvolution_methods}
\usage{
compare_deconvolution_methods(
  count_file,
  signature_matrix,
  print_plot = FALSE,
  order_celltype = NULL,
  useWGCNA = TRUE
)
}
\arguments{
\item{count_file}{Normalized (CPM, TPM, RPKM) RNA-seq count matrix where rows are gene symbols and columns are individuals. Either the object itself of the path of a .tsv file.}

\item{signature_matrix}{Signature matrix (odds ratios) of cell-type specificity of genes. Either the object itself or a pathway to an .RData file containing an object named "wilcoxon_rank_mat_or" - generally internal.}

\item{print_plot}{print the barplot of estimated cell-type proportions from each method into the R console (logical: TRUE/FALSE)}

\item{order_celltype}{Specify the order that cell-type are placed on the barplot. NULL = alphabetical, otherwise a character vector of cell-type labels (i.e. column names of the signature matrix).}

\item{useWGCNA}{specify if WGCNA is installed = TRUE/FALSE.}
}
\value{
List with the following elements:
\item{cellWeighted_Foldchange}{data frame of cellweightedFold-changes for each gene.}
\item{cellType_Proportions}{data frame of cell-type proportions from DeconRNA-seq.}
\item{leave_one_out_proportions}{data frame of average cell-type proportions for case and control when gene is removed.}
\item{processed_signature_matrix}{signature matrix used in final analysis.}
}
\description{
This function calculates cell-type proportions of an inputted bulk sample using DeconRNA-seq, WGCNA, and DCQ methods. Outputted cell-type proportions are then compared.
}
\examples{
\donttest{
 
data(PBMC_example)
norm_counts <- PBMC_example$bulk_normalized
signature <- PBMC_example$odds_ratio_in
tst <- compare_deconvolution_methods(count_file = norm_counts, 
 signature_matrix = signature, print_plot = FALSE,
 order_celltype = c("I_mono", "C_mono", "CD8_CM", "CD8_TE", 
 "B_SM", "B_NSM", "B_naive"), useWGCNA = FALSE)
}
 
}
