% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{Meta_Present}
\alias{Meta_Present}
\title{Check if meta data are present}
\usage{
Meta_Present(
  object,
  meta_col_names,
  print_msg = TRUE,
  omit_warn = TRUE,
  return_none = FALSE
)
}
\arguments{
\item{object}{Seurat or Liger object name.}

\item{meta_col_names}{vector of column names to check.}

\item{print_msg}{logical. Whether message should be printed if all features are found.  Default is TRUE.}

\item{omit_warn}{logical. Whether to print message about features that are not found in current object. Default is TRUE.}

\item{return_none}{logical. Whether list of found vs. bad features should still be returned if no
\code{meta_col_names} are found.  Default is FALSE.}
}
\value{
vector of meta data columns that are present
}
\description{
Check if meta data columns are present in object and return vector of found columns
Return warning messages for meta data columns not found.
}
\examples{
\dontrun{
meta_variables <- Meta_Present(object = obj_name, meta_col_names = "percent_mito", print_msg = TRUE)
}

}
\concept{check_util}
