% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Color_Palettes.R
\name{scCustomize_Palette}
\alias{scCustomize_Palette}
\title{Color Palette Selection for scCustomize}
\usage{
scCustomize_Palette(num_groups, ggplot_default_colors, color_seed = 123)
}
\arguments{
\item{num_groups}{number of groups to be plotted. If \code{ggplot_default_colors = FALSE} then by default:
\itemize{
\item If number of levels plotted equal to 2 then colors will be \code{NavyAndOrange()}.
\item If If number of levels plotted greater than 2 but less than or equal to 36 it will use "polychrome" from \code{DiscretePalette_scCustomize}.
\item If greater than 36 will use "varibow" with shuffle = TRUE from \code{DiscretePalette_scCustomize}.
}}

\item{ggplot_default_colors}{logical.  Whether to use default ggplot hue palette or not.}

\item{color_seed}{random seed to use for shuffling the "varibow" palette.}
}
\value{
vector of colors to use for plotting.
}
\description{
Function to return package default discrete palettes depending on number of groups plotted.
}
\examples{
cols <- scCustomize_Palette(num_groups = 24, ggplot_default_colors = FALSE)
PalettePlot(palette = cols)

}
\concept{palettes}
