% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_get.R
\name{item_get}
\alias{item_get}
\title{Retrieve SB item}
\usage{
item_get(sb_id, ..., session = current_session())
}
\arguments{
\item{sb_id}{An \code{\link{sbitem}} object or a character ScienceBase ID corresponding to the item}

\item{...}{Additional parameters are passed on to \code{\link[httr]{GET}}, \code{\link[httr]{POST}},
\code{\link[httr]{HEAD}}, \code{\link[httr]{PUT}}, or \code{\link[httr]{DELETE}}}

\item{session}{Session object from \code{\link{authenticate_sb}}. Defaults to anonymous or 
last authenticated session}
}
\value{
An object of class \code{sbitem}
}
\description{
Retrieves an item and its metadata from ScienceBase based on its
unique ID. Errors if the requested item ID does not exist or
access is restricted due to permissions.
}
\examples{
\donttest{
# Get an item
item_get("4f4e4b24e4b07f02db6aea14")

# Search for item IDs, then pass to item_get
library("httr")
res <- query_items(list(s = "Search", q = "water", format = "json"))

if(inherits(res, "response") && res$status != 404) {
  ids <- vapply(httr::content(res)$items, "[[", "", "id")
  lapply(ids[1:3], item_get)
}

}
}
