% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/items_update.R
\name{items_update}
\alias{items_update}
\title{Update many SB items with new metadata}
\usage{
items_update(sb_id, info, ..., session = current_session())
}
\arguments{
\item{sb_id}{An \code{\link{sbitem}} object or a character ScienceBase ID 
corresponding to the item}

\item{info}{list of metadata info (key-value pairs) to change on the item}

\item{...}{Additional parameters are passed on to \code{\link[httr]{PUT}}}

\item{session}{Session object from \code{\link{authenticate_sb}}. Defaults to anonymous or 
last authenticated session}
}
\value{
One or more objects of class \code{sbitem} in a list
}
\description{
A method to update multiple ScienceBase items with a single call and a single HTTP service
request. Can be useful for improving performance of updating a large number of items at once.
}
\details{
If length of \code{sb_id} > 1, then length of \code{info} input must be the same
}
\examples{
\dontrun{
# helper function to make a random name
aname <- function() paste0(sample(letters, size = 5, replace = TRUE), collapse = "")

res <- items_create(user_id(), title = c(aname(), aname())) 
out <- items_update(res, info = list( list(title = aname()), list(title = aname()) ) )
vapply(out, "[[", "", "title")
}
}
