% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_rm.R
\name{item_rm}
\alias{item_rm}
\title{Remove item from SB}
\usage{
item_rm(
  sb_id,
  ...,
  limit = 1000,
  recursive = FALSE,
  session = current_session()
)
}
\arguments{
\item{sb_id}{An \code{\link{sbitem}} object or a character ScienceBase ID corresponding to the item}

\item{...}{Additional parameters are passed on to \code{\link[httr]{GET}}, \code{\link[httr]{POST}},
\code{\link[httr]{HEAD}}, \code{\link[httr]{PUT}}, or \code{\link[httr]{DELETE}}}

\item{limit}{The maximum number of child items to remove when called with
recursive=TRUE.}

\item{recursive}{logical, FALSE by default. CAUTION: setting recursive=TRUE
means that not only will this item be deleted, but so will all its child
items and their child items and so on.}

\item{session}{Session object from \code{\link{authenticate_sb}}. Defaults to anonymous or 
last authenticated session}
}
\value{
\pkg{httr} \code{\link[httr]{response}} object
}
\description{
Remove an item from ScienceBase. This is not reversible and will delete 
an item and its attached files. (advanced) Recursive is to be used with care
and could result in unexpected file deletion.
}
\examples{
\dontrun{
res <- item_create(user_id(), "item-to-delete")
item_rm(res)
}
}
