% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbpiper_pe.r
\name{sampled_ple_analysis}
\alias{sampled_ple_analysis}
\title{Run the profile likelihood estimation analysis.}
\usage{
sampled_ple_analysis(model, filename, parameter, plots_dir,
  fileout_param_estim_summary, logspace = TRUE, scientific_notation = TRUE)
}
\arguments{
\item{model}{the model name}

\item{filename}{the filename containing the fits sequence}

\item{parameter}{the parameter to compute the PLE analysis}

\item{plots_dir}{the directory to save the generated plots}

\item{fileout_param_estim_summary}{the name of the file containing the summary for the parameter estimation}

\item{logspace}{true if parameters should be plotted in logspace. (default: TRUE)}

\item{scientific_notation}{true if the axis labels should be plotted in scientific notation (default: TRUE)}
}
\description{
Run the profile likelihood estimation analysis.
}
\examples{
dir.create(file.path("pe_datasets"))
dir.create(file.path("pe_plots"))
data(insulin_receptor_all_fits)
write.table(insulin_receptor_all_fits, 
            file=file.path("pe_datasets", "all_fits.csv"), 
            row.names=FALSE)
# generate the global statistics for the parameter estimation
pe_ds_preproc(filename=file.path("pe_datasets", "all_fits.csv"), 
              param.names=c('k1', 'k2', 'k3'), 
              logspace=TRUE, 
              all.fits=TRUE, 
              data_point_num=33, 
              fileout_param_estim_summary=file.path("pe_datasets", "param_estim_summary.csv"))
sampled_ple_analysis(model="ir_beta", 
                     filename=file.path("pe_datasets", "all_fits_log10.csv"), 
                     parameter="k1", 
                     plots_dir="pe_plots", 
                     fileout_param_estim_summary=file.path("pe_datasets", 
                                                           "param_estim_summary.csv"),
                     logspace=TRUE)
}
