% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbpiper_plots.r
\name{plot_repeated_tc}
\alias{plot_repeated_tc}
\title{Plot repeated time courses in the same plot separately. First column is Time.}
\usage{
plot_repeated_tc(df, g = ggplot(), title = "", xaxis_label = "",
  yaxis_label = "", alpha = 1, yaxis.min = NULL, yaxis.max = NULL)
}
\arguments{
\item{df}{a data frame}

\item{g}{the current ggplot to overlap}

\item{title}{the title of the plot}

\item{xaxis_label}{the xaxis label of the plot}

\item{yaxis_label}{the yaxis label of the plot}

\item{alpha}{the amount of alpha transparency}

\item{yaxis.min}{the lower limit for the y axis}

\item{yaxis.max}{the upper limit for the y axis}
}
\value{
the plot
}
\description{
Plot repeated time courses in the same plot separately. First column is Time.
}
\examples{
data(insulin_receptor_1)
data(insulin_receptor_2)
data(insulin_receptor_3)
df <- data.frame(Time=insulin_receptor_1[,1], 
                 X1=insulin_receptor_1[,2], 
                 X2=insulin_receptor_2[,2], 
                 X3=insulin_receptor_3[,2])
plot_repeated_tc(df=df, 
                 xaxis_label="Time [m]", yaxis_label="Level [a.u.]", 
                 alpha=1, yaxis.min=NULL, yaxis.max=NULL)
}
