% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbpiper_pe.r
\name{pe_ds_preproc}
\alias{pe_ds_preproc}
\title{Parameter estimation pre-processing. It renames the data set columns, and applies a log10 transformation if logspace is TRUE.
If all.fits is true, it also computes the confidence levels.}
\usage{
pe_ds_preproc(filename, param.names = c(), logspace = TRUE,
  all.fits = FALSE, data_point_num = 0,
  fileout_param_estim_summary = "param_estim_summary.csv")
}
\arguments{
\item{filename}{the dataset filename containing the fits sequence}

\item{param.names}{the list of estimated parameter names}

\item{logspace}{true if the data set shoud be log10-transformed.}

\item{all.fits}{true if filename contains all fits, false otherwise}

\item{data_point_num}{the number of data points used for parameterise the model. Ignored if all.fits is false}

\item{fileout_param_estim_summary}{the name of the file containing the summary for the parameter estimation. Ignored if all.fits is false}
}
\description{
Parameter estimation pre-processing. It renames the data set columns, and applies a log10 transformation if logspace is TRUE.
If all.fits is true, it also computes the confidence levels.
}
\examples{
dir.create(file.path("pe_datasets"))
data(insulin_receptor_all_fits)
write.table(insulin_receptor_all_fits, 
            file=file.path("pe_datasets", "all_fits.csv"), 
            row.names=FALSE)
pe_ds_preproc(filename=file.path("pe_datasets", "all_fits.csv"), 
              param.names=c('k1', 'k2', 'k3'), 
              logspace=TRUE, 
              all.fits=TRUE, 
              data_point_num=33, 
              fileout_param_estim_summary=file.path("pe_datasets", "param_estim_summary.csv"))
data(insulin_receptor_best_fits)
write.table(insulin_receptor_best_fits, 
            file=file.path("pe_datasets", "best_fits.csv"), 
            row.names=FALSE)
pe_ds_preproc(filename=file.path("pe_datasets", "best_fits.csv"), 
              param.names=c('k1', 'k2', 'k3'), 
              logspace=TRUE, 
              all.fits=FALSE)
}
