% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/satres.R
\name{as_SpatRaster}
\alias{as_SpatRaster}
\alias{as_SpatRaster.satres}
\title{As \code{terra} \code{SpatRaster} class}
\usage{
as_SpatRaster(sr, res)

\method{as_SpatRaster}{satres}(sr, res = NULL)
}
\arguments{
\item{sr}{A \code{satres} object.}

\item{res}{A string, spatial resolution.}
}
\value{
A vector of strings.
}
\description{
Returns the multi-band raster of the indicated spatial resolution as an object
of class \code{SpatRaster} from package \code{terra}
}
\examples{

esa <- system.file("extdata", "esa", package = "satres")
sr <- satres(dir = esa,
             out_dir = tempdir())

r <- sr |>
     as_SpatRaster("r1000m")

}
\seealso{
\code{\link{sat_untarzip}}

Other satellite functions: 
\code{\link{get_spatial_resolution}()},
\code{\link{satres}()},
\code{\link{save_by_resolution}()}
}
\concept{satellite functions}
