% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\docType{methods}
\name{plot}
\alias{plot}
\alias{plot,Satellite,ANY-method}
\alias{plot,Satellite-method}
\title{Plot a Satellite object}
\usage{
\S4method{plot}{Satellite,ANY}(x, bcde = NULL,
  col = grDevices::grey.colors(100), ...)
}
\arguments{
\item{x}{A 'Satellite' object, usually returned by \code{\link{satellite}}.}

\item{bcde}{Band codes to be visualized, e.g. returned by 
\code{\link{getSatBCDE}}. If not supplied, the initial (up to) 16 layers are 
being visualized.}

\item{col}{Color scheme.}

\item{...}{Further arguments passed on to \code{\link{plot.default}}.}
}
\description{
This is the standard plotting routine for the 'Satellite' class. Layers are 
drawn either from the start (default; limited to a maximum of 16 sub-plots) 
or according to the speficied band codes.
}
\examples{
\dontrun{
## sample data
path <- system.file("extdata", package = "satellite")
files <- list.files(path, pattern = glob2rx("LC08*.TIF"), full.names = TRUE)
sat <- satellite(files)

## display data without quality flag layer
bds <- getSatBCDE(sat)[1:11]
plot(sat, bcde = bds)
}

}
\seealso{
\code{\link{plot.default}}, \code{\link{par}}.
}
