% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeSLAB.R
\name{computeSLABrhogs}
\alias{computeSLABrhogs}
\title{Compute 'density over grain size' averaged over slab}
\usage{
computeSLABrhogs(profile, implementation = c("pub", "literal")[1])
}
\arguments{
\item{profile}{\link{snowprofile} object}

\item{implementation}{\code{"pub"} for \verb{<rho/gs>_slab}, \code{"literal"} for 'mean density of slab over mean grain size of slab' \verb{<rho>_slab / <gs>_slab}.}
}
\value{
snowprofile object with added layers column \verb{$slab_rhogs}. Note that topmost layer is always \code{NA}.
}
\description{
For each layer, compute the average density over grain size of all layers above, i.e. \verb{<rho/gs>_slab}.
This variable has been found to characterize the cohesion of slabs: new snow slabs tend to consist of low density & large grains, and
more cohesive slabs of older snow tend to consist of higher density & smaller grains (Mayer et al, 2022 in review).
}
\author{
fherla
}
