% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getColoursLWC.R
\name{getColoursLWC}
\alias{getColoursLWC}
\title{Gets colours for plotting LWC values}
\usage{
getColoursLWC(Values, Resolution = 101, Verbose = FALSE)
}
\arguments{
\item{Values}{Liquid water content values}

\item{Resolution}{Resolution of colour scale. Default is 100.}

\item{Verbose}{Switch for writing out value and html colour tuplets for debugging.}
}
\value{
Array with HTML colour codes
}
\description{
Gets colours for plotting LWC values in snowprofiles. Colours are consistent with niViz at https://niviz.org
}
\examples{

LWC <- seq(0,6, by = 0.1)
plot(x = rep(1,length(LWC)), y = LWC, col = getColoursLWC(LWC), pch = 19, cex = 3)

}
\seealso{
\link{getColoursDensity}, \link{getColoursGrainSize}, \link{getColoursGrainType}, \link{getColoursHardness}, \link{getColoursSnowTemp}
}
\author{
phaegeli
}
