% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findPWL.R, R/labelPWL.R
\name{findPWL}
\alias{findPWL}
\alias{labelPWL}
\title{Find layers of interest (e.g. PWLs) in snowprofile(Layers)}
\usage{
findPWL(
  x,
  pwl_gtype = c("SH", "DH"),
  pwl_date = NA,
  date_range_earlier = as.difftime(5, units = "days"),
  date_range_later = as.difftime(0, units = "days"),
  bdate_range_earlier = as.difftime(1, units = "days"),
  bdate_range_later = as.difftime(1, units = "days"),
  threshold_gtype = pwl_gtype,
  threshold_gsize = NA,
  threshold_TSA = NA,
  threshold_RTA = NA,
  threshold_NA = TRUE
)

labelPWL(x, ...)
}
\arguments{
\item{x}{\link{snowprofile} or \link{snowprofileLayers} object}

\item{pwl_gtype}{a vector of grain types of interest}

\item{pwl_date}{a date of interest given as character ('YYYY-MM-DD') or as POSIXct; set to \code{NA} to ignore dates.}

\item{date_range_earlier}{a \link{difftime} object that defines a date search window prior to \code{pwl_date}. This date range is applied to \code{ddate}s (deposition dates),
or if these are not available to \code{datetag}s.}

\item{date_range_later}{analogous to \code{date_range_earlier}}

\item{bdate_range_earlier}{analogous to \code{date_range_earlier}, but applied to \code{bdate}s (burial dates).}

\item{bdate_range_later}{analogous to \code{bdate_range_earlier}.}

\item{threshold_gtype}{specific grain types that are only deemed a PWL if they pass a certain threshold (see next parameters)}

\item{threshold_gsize}{a threshold grain size in order to deem \code{threshold_gtype} a PWL; set to \code{NA} to ignore grain sizes.}

\item{threshold_TSA}{a threshold TSA value (see \link{computeTSA}) in order to deem \code{threshold_gtype} a PWL; set to \code{NA} to ignore TSA.}

\item{threshold_RTA}{a threshold RTA value (see \link{computeRTA}) in order to deem \code{threshold_gtype} a PWL; set to \code{NA} to ignore RTA.}

\item{threshold_NA}{if the threshold you want to apply to \code{threshold_gtype} is \code{NA}, do you then want to deem the layer a PWL (i.e., set \code{TRUE}) or not (i.e., set to \code{FALSE})?}

\item{...}{passed on to \link{findPWL}}
}
\value{
\code{findPWL}: An index vector of PWLs that match the desired requirements

\code{labelPWL}: The input object with an extra boolean column appended to the layer object, called \verb{$layerOfInterest}.
}
\description{
Find one or more layers of interest, such as persistent weak layers (PWL) in a snowprofile or snowprofileLayers object based on combinations of grain type, datetag, grain size,
and stability indices (TSA/ RTA) of the layer. The routine can also be used for searching for crusts (or any other grain types).
}
\details{
In case date considerations are included in your search: at least one of the two conditions \emph{(b)date_range_earlier} \strong{AND} at least one
of the two conditions \emph{(b)date_range_later} needs to be satisfied to return a given layer. If the input object contains deposition dates (\code{ddate}, mostly in simulated profiles),
then the date window is applied to both \code{ddate} and a newly computed \code{bdate};
otherwise the date window is applied to the \code{datetag} (mostly for manual profiles).

The \code{labelPWL} wrapper function is primarily used by \code{sarp.snowprofile.alignment::averageSP}.
}
\section{Functions}{
\itemize{
\item \code{findPWL}: Find layers of interest (e.g., PWLs) in \code{snowprofile} or \code{snowprofileLayers}

\item \code{labelPWL}: Label layers of interest (e.g., weak layers) in \code{snowprofile}
}}

\examples{
## get index vector:
findPWL(SPpairs$A_modeled)

## get layers subset:
SPpairs$A_manual$layers[findPWL(SPpairs$A_manual), ]
SPpairs$A_manual$layers[findPWL(SPpairs$A_manual, threshold_gsize = 2.2,
                        threshold_gtype = c("FC", "FCxr")), ]
## all (SH, DH), and (FC, FCxr) >= 1 mm grain size:
SPpairs$A_modeled$layers[findPWL(SPpairs$A_modeled, pwl_gtype = c("SH", "DH", "FC", "FCxr"),
                                 threshold_gsize = 1, threshold_gtype = c("FC", "FCxr")), ]
## use TSA threshold:
SPpairs$A_modeled <- computeTSA(SPpairs$A_modeled)
SPpairs$A_modeled$layers[findPWL(SPpairs$A_modeled, pwl_gtype = c("SH", "DH", "FC", "FCxr"),
                                 threshold_TSA = 4, threshold_gtype = c("FC", "FCxr")), ]

## searching for a specific pwl_date:
SPpairs$A_manual$layers[findPWL(SPpairs$A_manual, pwl_date = "2019-02-18"), ]
## Why is there a layer included without date information?!
## --> because the layers 'bdate' can be computed from the known 'ddate' of the layer above
## and the resulting 'bdate' lies within the allowed 'date_range'...

## can also be used to search for crusts:
SPpairs$A_manual$layers[findPWL(SPpairs$A_manual, pwl_gtype = "MFcr"), ]

}
\author{
fherla
}
