% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snowprofile.R
\name{snowprofile}
\alias{snowprofile}
\title{High-level constructor for a snowprofile object}
\usage{
snowprofile(
  station = as.character(NA),
  station_id = as.character(NA),
  datetime = as.POSIXct(NA, tz = "UTC"),
  latlon = as.double(c(NA, NA)),
  elev = as.double(NA),
  angle = as.double(NA),
  aspect = as.double(NA),
  hs = as.double(NA),
  type = "manual",
  band = as.character(NA),
  zone = as.character(NA),
  layers = snowprofileLayers(formatTarget = "FALSE", dropNAs = FALSE),
  validate = TRUE,
  dropNAs = TRUE
)
}
\arguments{
\item{station}{character string}

\item{station_id}{character string}

\item{datetime}{date and time as class POSIXct in most meaningful timezone (timezone can be converted very easily:
e.g. \code{print(profile$datetime, tz = 'EST')}.}

\item{latlon}{2-element vector latitude (first), longitude (second)}

\item{elev}{profile elevation (m)}

\item{angle}{slope angle (degree)}

\item{aspect}{slope aspect (degree)}

\item{hs}{total snow height (cm); if not provided, the field will be derived from the profile layers.}

\item{type}{character string, must be either 'manual', 'modeled', 'vstation', 'aggregate', or 'whiteboard'}

\item{band}{character string describing elevation band as ALP, TL, BTL (alpine, treeline, below treeline)}

\item{zone}{character string describing the zone or region of the profile location (e.g., BURNABY_MTN)}

\item{layers}{\link{snowprofileLayers} object}

\item{validate}{Validate the object with \link{validate_snowprofile}?}

\item{dropNAs}{Do you want to drop non-mandatory \code{snowprofile} and \code{snowprofileLayers} fields that are \code{NA} only?}
}
\value{
snowprofile object
}
\description{
Conveniently create a snowprofile object. Calls low-level constructor (only available internally: \link{new_snowprofile}), asserts correctness
through a snowprofile validator function (\link{validate_snowprofile}) and yields meaningful error messages. Use low-level constructor if you generate many (!) profiles.
}
\examples{

## Empty snowprofile:
snowprofile()

## Test profile:
testProfile <- snowprofile(station = 'SARPstation', station_id = 'SARP007',
                           datetime = as.POSIXct('2019/04/01 10:00:00', tz = 'PDT'),
                           latlon = c(49.277223, -122.915084), aspect = 180,
                           layers = snowprofileLayers(height = c(10, 25, 50),
                                                      hardness = c(3, 2, 1),
                                                      gtype = c('FC', NA, 'PP')))
summary(testProfile)
plot(testProfile)

}
\seealso{
\link{summary.snowprofile}, \link{plot.snowprofile}, \link{snowprofileLayers}, \link{SPpairs}
}
\author{
shorton, fherla
}
