% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterSPconfig.R
\name{clusterSPconfig}
\alias{clusterSPconfig}
\title{Configure clusterSP computation}
\usage{
clusterSPconfig(
  type = "n",
  simType = NULL,
  ddate = FALSE,
  pwls = FALSE,
  n_cores = NULL,
  verbose = TRUE
)
}
\arguments{
\item{type}{which method of clustering, current options are \code{kdba} or default \code{n} which provides generic config}

\item{simType}{which profile similarity method is used for alignments, see \link{simSP} for options}

\item{ddate}{if profiles contain deposition date adjust the dimensions and weights used for layer similarities passed to \link{distanceSPlayers}}

\item{pwls}{if profiles contain stability indices then use that information to classify PWLS in \link{averageSP}}

\item{n_cores}{number of nodes passed to \link{averageSP} and \link{distanceSP} to run calculations in parallel, default NULL performs all calculations in serial}

\item{verbose}{logical indicating whether to print various diagnostics}
}
\value{
a list containing the following:
\itemize{
\item \code{args_distance}: a parameter list passed on to the distance function during clustering. This list will determine the distance
computation in clustering type \code{'kdba'}, and the computation of a distance matrix with \link{distanceSP} for other clustering types
\item \code{args_centers}: a parameter list passed on to \link{clusterSPcenters} during clustering
\item \code{args_cluster}: a parameter list passed onto the clustering functions \link[stats:hclust]{stats::hclust}, \link[cluster:pam]{cluster::pam}, \link[cluster:fanny]{cluster::fanny}, \link{clusterSPkdba}
\item \code{args_fast}: a named vectors with weights for summary stats used in in \code{fast} option
\item \code{verbose}: copied from the input parameter \code{verbose}
}
}
\description{
Configure the (hyper)parameters to computing snow profile clusters.
}
\examples{
print(clusterSPconfig(ddate = TRUE))
}
\seealso{
\link{clusterSP}
}
\author{
fherla shorton
}
